#version 420

const float etaR = 1.14;
const float etaG = 1.12;
const float etaB = 1.10;
const float fresnelPower = 2.0;
const float F = ((1.0 - etaG) * (1.0 - etaG)) / ((1.0 + etaG) * (1.0 + etaG));


uniform samplerCube envmap;
uniform float transparency;

const float reflect_factor = 1.0;

uniform vec3 campos;


in mat3 normal_matrix;
in vec4 world_pos;
in vec3 out_normal;
layout(location = 0) out vec4 fragColor;
layout(location = 1) out vec4 fragColor2;

void main (void)
{
    vec3 i = normalize( world_pos.xyz - campos.xyz );	
    vec3 n = normalize( normal_matrix * out_normal ).xyz; 

    float ratio = F + (1.0 - F) * pow(1.0 - dot(-i, n), fresnelPower);

    vec3 refractR = vec4(refract(i, n, etaR), 1.0).xyz;
    vec3 refractG = vec4(refract(i, n, etaG), 1.0).xyz;
    vec3 refractB = vec4(refract(i, n, etaB), 1.0).xyz;

    vec3 reflectDir = vec4(reflect(i, n), 1.0).xyz;

    vec4 refractColor;
    refractColor.ra = texture(envmap, refractR).ra;
    refractColor.g  = texture(envmap, refractG).g;
    refractColor.b  = texture(envmap, refractB).b;

    vec4 reflectColor;
    reflectColor    = texture(envmap, reflectDir);

    vec3 combinedColor = mix(refractColor, reflectColor, ratio).xyz;

    fragColor = vec4(combinedColor, 1.0);
    fragColor2 = vec4(1.0);
}